/**
 * \file: mspin_demo_iap2_types.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * mySPIN Demo iAP2 Types
 *
 * \component: MSPIN
 *
 * \author: Bui Le Thuan / thuan.buile@vn.bosch.com
 *          Thilo Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_IAP2_CONNECTION_TYPES_H_
#define MSPIN_IAP2_CONNECTION_TYPES_H_

#include <iap2_init.h>
#include <mqueue.h>

//#define MSPIN_DEMO_IAP2_APP_NAME "com.apple.p1"  //used for EADemo application (for testing only)
#define MSPIN_DEMO_IAP2_APP_NAME                                    "com.bosch.m"
#define MSPIN_DEMO_IAP2_BUNDLE_ID                                   "com.bosch.myspin.launcherapp.cn"

#define MYSPIN_MQ_MAX_SIZE                                          1024
#define MYSPIN_MQ_NAME                                              "/mySPIN_Mq"
#define MYSPIN_MQ_NAME_APP_TSK                                      "/mySPIN_TskMq"
#define MYSPIN_MQ_CMD_STOP_POLL                                     "mqStopPoll"

#define MYSPIN_DEMO_IAP2_ACC_INFO_NAME                              "AmazingProduct"
#define MYSPIN_DEMO_IAP2_ACC_INFO_MODEL_IDENTIFIER                  "15697"
#define MYSPIN_DEMO_IAP2_ACC_INFO_MANUFACTURER                      "BSOT"
#define MYSPIN_DEMO_IAP2_ACC_INFO_SERIAL_NUM                        "12345678"
#define MYSPIN_DEMO_IAP2_ACC_INFO_FW_VER                            "1"
#define MYSPIN_DEMO_IAP2_ACC_INFO_HW_VER                            "1"
#define MYSPIN_DEMO_IAP2_ACC_INFO_VENDOR_ID                         "44311"
#define MYSPIN_DEMO_IAP2_ACC_INFO_PRODUCT_ID                        "1111"
#define MYSPIN_DEMO_IAP2_ACC_INFO_BCD_DEVICE                        "1"
#define MYSPIN_DEMO_IAP2_ACC_INFO_INIT_ENDPOINT                     "/dev/ffs/ep0"

#define MYSPIN_DEMO_IAP2_ACC_CONFG_TRANS_USB_OTG_GPIO_POWER_SD      "86"
#define MYSPIN_DEMO_IAP2_ACC_CONFG_TRANS_USB_OTG_GPIO_POWER_AI      "425"

typedef struct
{
    iAP2Device_t *p_iAP2Device;
    iAP2DeviceState_t testDeviceState;
    mqd_t mqAppTskFd;
} mspin_demo_iap2_iOSDevice_t;

#endif /* MSPIN_IAP2_CONNECTION_TYPES_H_ */
